
*********************
***Brace adherence***
*********************

***************************************************************************************************************************************************************************************************************************
***Use the datafiles and analysis code below to reproduce the number participants wearing a brace in the AIE arm (as reported in the discussion section of the paper) and the analysis in eTable23 and eFigure 1 and 2*****
***************************************************************************************************************************************************************************************************************************

*************
**Datafiles***
*************

1) 466_brace use_both trial arms.dta

2) 237_AIEplusB_only.dta

3) 237_AIEplusB_only - imputed data.dta"

********************
***Analysis code****
********************

******************************************
**Checking for brace use in the AIE arm***
******************************************

***Apply code to datafile: 466_brace use_both trial arms.dta 

***The count of interest is the number of non-zero values in the variable A

egen A = rowmax(M3_B10 M3_B11 M6_B7 M6_B8 M12_B7 M12_B8) if Treat == 1
tab A
drop A

**********************************************************************************
***Analysing the reasons for not wearing the brace at each follow-up time-point***
**********************************************************************************

***Apply code to datafile: 237_AIEplusB_only.dta

***Note that some participants have given two answers in the other category, which is why the results are not directly copied from the output in the other section 
 
dtable i.Z_M3_B14_a i.Z_M3_B14_b i.Z_M3_B14_c i.Z_M3_B14_d i.Z_M3_B14_e i.Z_M3_B14_f i.Z_M3_B14_g i.Z_M3_B14_h i.Z_M3_B14_i i.Z_M3_B14_j i.Z_M3_B14_k i.Z_M3_B14_l i.Z_M3_B14_m i.Z_M3_B14_n i.Z_M3_B14_o i.Z_M3_B14_p i.Z_M3_B14_q if Z_M3_B14_a != . , nformat(%9.0f)

dtable i.Z_M6_B11a i.Z_M6_B11b i.Z_M6_B11c i.Z_M6_B11d i.Z_M6_B11e i.Z_M6_B11f i.Z_M6_B11g i.Z_M6_B11h i.Z_M6_B11i i.Z_M6_B11j i.Z_M6_B11k i.Z_M6_B11l i.Z_M6_B11m i.Z_M6_B11n i.Z_M6_B11o i.Z_M6_B11p i.Z_M6_B11q if Z_M6_B11a != ., nformat(%9.0f)

dtable i.Z_M12_B11a i.Z_M12_B11b i.Z_M12_B11c i.Z_M12_B11d i.Z_M12_B11e i.Z_M12_B11f i.Z_M12_B11g i.Z_M12_B11h i.Z_M12_B11i i.Z_M12_B11j i.Z_M12_B11k i.Z_M12_B11l i.Z_M12_B11m i.Z_M12_B11n i.Z_M12_B11o i.Z_M12_B11p i.Z_M12_B11q if Z_M12_B11a != . , nformat(%9.0f)

***********************************************
***Analysis of brace use - imputed data file***
***********************************************

***Apply code to datafile: 237_AIEplusB_only - imputed data.dta"

***It's necessary to use all the decimal places in the calculation of the number of participants otherwise the number of participants in the categories doesn't add to the total. This is why the cformat command is used below 

set cformat %9.8f

***Brace use questions on the questionnaire 

foreach var in M3_B10 M6_B7 M12_B7 {
	mi estimate: proportion `var' 
}

foreach var in M3_B10 M6_B7 M12_B7 M3_B11 M6_B8 M12_B8 M3_brace_time M6_brace_time M12_brace_time {
	misum  `var' , detail format(%9.1f)
	return list
}

***Generating the data for a plot of the total time wearing the brace over time from the SMS text message data

set cformat %9.2f

foreach i of numlist 1 2 3 4 5 6 7 8 9 10 11 12 {
mi estimate: mean SMS`i'_brace_time
}

foreach i of numlist 1 2 3 4 5 6 7 8 9 10 11 12 {
misum SMS`i'_brace_time, detail
return list
}

mi estimate: mean Average_brace_time
misum Average_brace_time, detail
return list

***Generating the data for a plot of the minimum time wearing the brace over time from the SMS text message data

set cformat %9.2f

foreach i of numlist 1 2 3 4 5 6 7 8 9 10 11 12 {
mi estimate: proportion SMS`i'_min_brace 
}

mi estimate: mean Average_min_brace 

***************************
****Producing data plots***
***************************

**Use the files stored in the folder called "graphs" to produce the plots below

****Plotting total brace wear time (mean)

import excel "Data for brace use plot.xlsx", sheet("Brace use") firstrow clear

twoway rcap Total_Time_LowerCI Total_Time_UpperCI Time || (connected Total_Time_Mean Time), xlabel(0(4)52) ylabel(0(10)130) 

graph play "Brace time - graph recording - mean.grec"

****Plotting total brace wear time (median)

twoway rbar Total_Time_p25 Total_Time_Median Time, pstyle(p1) || rbar Total_Time_Median Total_Time_p75 Time, pstyle(p1) || rspike  Total_Time_p25 Total_Time_Min Time, pstyle(p1) || rspike Total_Time_p75 Total_Time_Max Time, pstyle(p1) || rcap Total_Time_Min Total_Time_Min Time, pstyle(p1) || rcap Total_Time_Max Total_Time_Max Time, legend(off) pstyle(p1) 

graph play "Brace time - graph recording - median.grec"

****Plotting minimum brace wear

twoway rcap Min_Time_LowerCI Min_Time_UpperCI Time || (connected Min_Time_Prop Time), xlabel(0(4)52) ylabel(0(10)100)

graph play "Minimum brace wear - graph recording.grec"
